import type { GridColumnApi } from "./gridColumnApi.js";
import type { GridColumnMenuApi } from "./gridColumnMenuApi.js";
import type { GridCoreApi, GridCorePrivateApi } from "./gridCoreApi.js";
import type { GridCsvExportApi } from "./gridCsvExportApi.js";
import type { GridDensityApi } from "./gridDensityApi.js";
import type { GridEditingApi, GridEditingPrivateApi } from "./gridEditingApi.js";
import type { GridFilterApi } from "./gridFilterApi.js";
import type { GridFocusApi, GridFocusPrivateApi } from "./gridFocusApi.js";
import type { GridLocaleTextApi } from "./gridLocaleTextApi.js";
import type { GridParamsApi, GridParamsPrivateApi } from "./gridParamsApi.js";
import type { GridPreferencesPanelApi } from "./gridPreferencesPanelApi.js";
import type { GridPrintExportApi } from "./gridPrintExportApi.js";
import type { GridRowApi, GridRowProPrivateApi } from "./gridRowApi.js";
import type { GridRowsMetaApi, GridRowsMetaPrivateApi } from "./gridRowsMetaApi.js";
import type { GridRowSelectionApi } from "./gridRowSelectionApi.js";
import type { GridSortApi } from "./gridSortApi.js";
import type { GridStateApi, GridStatePrivateApi } from "./gridStateApi.js";
import type { GridLoggerApi } from "./gridLoggerApi.js";
import type { GridScrollApi } from "./gridScrollApi.js";
import type { GridVirtualizationApi, GridVirtualizationPrivateApi } from "./gridVirtualizationApi.js";
import type { GridPipeProcessingApi, GridPipeProcessingPrivateApi } from "../../hooks/core/pipeProcessing/index.js";
import type { GridColumnSpanningApi, GridColumnSpanningPrivateApi } from "./gridColumnSpanning.js";
import type { GridStrategyProcessingApi } from "../../hooks/core/strategyProcessing/index.js";
import type { GridDimensionsApi, GridDimensionsPrivateApi } from "../../hooks/features/dimensions/gridDimensionsApi.js";
import type { GridPaginationApi } from "../../hooks/features/pagination/index.js";
import type { GridStatePersistenceApi } from "../../hooks/features/statePersistence/index.js";
import type { GridColumnGroupingApi } from "./gridColumnGroupingApi.js";
import type { GridInitialStateCommunity, GridStateCommunity } from "../gridStateCommunity.js";
import type { GridHeaderFilteringApi, GridHeaderFilteringPrivateApi } from "./gridHeaderFilteringApi.js";
import type { DataGridProcessedProps } from "../props/DataGridProps.js";
import type { GridColumnResizeApi } from "../../hooks/features/columnResize/index.js";
import type { GridPivotingPrivateApiCommunity } from "../../hooks/features/pivoting/gridPivotingInterfaces.js";
export interface GridApiCommon<GridState extends GridStateCommunity = any, GridInitialState extends GridInitialStateCommunity = any> extends GridCoreApi, GridPipeProcessingApi, GridDensityApi, GridDimensionsApi, GridRowApi, GridRowsMetaApi, GridEditingApi, GridParamsApi, GridColumnApi, GridRowSelectionApi, GridSortApi, GridPaginationApi, GridCsvExportApi, GridFocusApi, GridFilterApi, GridColumnMenuApi, GridPreferencesPanelApi, GridPrintExportApi, GridVirtualizationApi, GridLocaleTextApi, GridScrollApi, GridColumnSpanningApi, GridStateApi<GridState>, GridStatePersistenceApi<GridInitialState>, GridColumnGroupingApi, GridHeaderFilteringApi, GridColumnResizeApi {}
export interface GridPrivateOnlyApiCommon<Api extends GridApiCommon, PrivateApi extends GridPrivateApiCommon, Props extends DataGridProcessedProps> extends GridCorePrivateApi<Api, PrivateApi, Props>, GridStatePrivateApi<PrivateApi['state']>, GridPipeProcessingPrivateApi, GridStrategyProcessingApi, GridColumnSpanningPrivateApi, GridRowsMetaPrivateApi, GridDimensionsPrivateApi, GridEditingPrivateApi, GridLoggerApi, GridFocusPrivateApi, GridHeaderFilteringPrivateApi, GridVirtualizationPrivateApi, GridRowProPrivateApi, GridParamsPrivateApi, GridPivotingPrivateApiCommunity {}
export interface GridPrivateApiCommon extends GridApiCommon, GridPrivateOnlyApiCommon<GridApiCommon, GridPrivateApiCommon, DataGridProcessedProps> {}